<?php
/* --------------------------------------------------------------
 routes.php 2020-04-07
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

use Gambio\Api\Application\BaseApiV3Controller;
use Gambio\Api\Application\Middleware\AuthenticationMiddleware;
use Gambio\Api\Application\Middleware\RateLimitMiddleware;
use Gambio\Api\Application\Middleware\VersionsMiddleware;
use Gambio\Api\ParcelService\Actions\CreateParcelServicesAction;
use Gambio\Api\ParcelService\Actions\DeleteParcelServicesAction;
use Gambio\Api\ParcelService\Actions\FetchAllParcelServicesAction;
use Gambio\Api\ParcelService\Actions\FetchSpecificParcelServiceAction;
use Gambio\Api\ParcelService\Actions\UpdateParcelServicesAction;
use Gambio\Api\TrackingCode\Actions\CreateTrackingCodesAction;
use Gambio\Api\TrackingCode\Actions\DeleteTrackingCodesAction;
use Gambio\Api\TrackingCode\Actions\FetchAllTrackingCodesAction;
use Gambio\Api\TrackingCode\Actions\FetchSpecificTrackingCodeAction;
use Gambio\Api\TrackingCode\Actions\UpdateTrackingCodesAction;
use Gambio\Api\Withdrawal\Actions\CreateWithdrawalsAction;
use Gambio\Api\Withdrawal\Actions\DeleteWithdrawalsAction;
use Gambio\Api\Withdrawal\Actions\FetchAllWithdrawalsAction;
use Gambio\Api\Withdrawal\Actions\FetchSpecificWithdrawalAction;
use Gambio\Api\Withdrawal\Actions\UpdateWithdrawalsAction;
use Slim\App as SlimApp;
use Slim\Routing\RouteCollectorProxy;

return static function (SlimApp $slimApp) {
    $slimApp->group('/api.php/v3',
        function (RouteCollectorProxy $group) {
            /**
             * WITHDRAWALS ENDPOINTS
             */
            $group->group('/withdrawals',
                function (RouteCollectorProxy $group) {
                    $group->get('', FetchAllWithdrawalsAction::class);
                    $group->post('', CreateWithdrawalsAction::class);
                    $group->put('', UpdateWithdrawalsAction::class);
                    $group->delete('/{ids:[0-9,]+}', DeleteWithdrawalsAction::class);
                    $group->get('/{id:[0-9]+}', FetchSpecificWithdrawalAction::class);
                });
            /**
             * PARCEL SERVICES ENDPOINTS
             */
            $group->group('/parcel-services',
                function (RouteCollectorProxy $group) {
                    $group->get('', FetchAllParcelServicesAction::class);
                    $group->post('', CreateParcelServicesAction::class);
                    $group->put('', UpdateParcelServicesAction::class);
                    $group->delete('/{ids:[0-9,]+}', DeleteParcelServicesAction::class);
                    $group->get('/{id:[0-9]+}', FetchSpecificParcelServiceAction::class);
                });
            /**
             * TRACKING CODES ENDPOINTS
             */
            $group->group('/tracking-codes',
                function (RouteCollectorProxy $group) {
                    $group->get('', FetchAllTrackingCodesAction::class);
                    $group->post('', CreateTrackingCodesAction::class);
                    $group->put('', UpdateTrackingCodesAction::class);
                    $group->delete('/{ids:[0-9,]+}', DeleteTrackingCodesAction::class);
                    $group->get('/{id:[0-9]+}', FetchSpecificTrackingCodeAction::class);
                });
            /**
             * BASE ENDPOINT
             */
            $group->get('', BaseApiV3Controller::class);
        })->add(RateLimitMiddleware::class)->add(AuthenticationMiddleware::class)->add(VersionsMiddleware::class);
};
